function vB_AJAX_MediaRate_Init(formid)
{
	var formobj = fetch_object(formid);
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2) && formobj)
	{
		for (var i = 0; i < formobj.elements.length; i++)
		{
			if (formobj.elements[i].type == 'submit')
			{
				// prevent the form from submitting when clicking the submit button
				var sbutton = formobj.elements[i];
				var button = document.createElement('input');
				button.type = 'button';
				button.className = sbutton.className;
				button.value     = sbutton.value;
				button.onclick   = vB_AJAX_MediaRate.prototype.form_click;
				sbutton.parentNode.insertBefore(button, sbutton);
				sbutton.parentNode.removeChild(sbutton);
			}
		}
	}
};

function vB_AJAX_MediaRate(formobj)
{
	this.formobj = formobj;

	this.pseudoform = new vB_Hidden_Form('mediarate.php');
	this.pseudoform.add_variable('ajax', 1);
	this.pseudoform.add_variables_from_object(this.formobj);

	// Output object
	this.output_element_id = 'mediarating_current';
	this.output_element_id2 = 'media_rate';
};

vB_AJAX_MediaRate.prototype.handle_ajax_response = function(ajax)
{
	if (ajax.responseXML)
	{
		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			if (vBmenu.activemenu == 'mediarating')
			{
				vBmenu.hide();
			}
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			var newrating = ajax.responseXML.getElementsByTagName('voteavg');
			var mediarating = ajax.responseXML.getElementsByTagName('mediavg');
			if (newrating.length && newrating[0].firstChild && newrating[0].firstChild.nodeValue != "")
			{
				fetch_object(this.output_element_id).innerHTML = newrating[0].firstChild.nodeValue;
				fetch_object(this.output_element_id2).innerHTML = mediarating[0].firstChild.nodeValue;
			}
			if (vBmenu.activemenu == 'mediarating')
			{
				vBmenu.hide();
			}

			var message = ajax.responseXML.getElementsByTagName('message');
			if (message.length)
			{
				alert(message[0].firstChild.nodeValue);
			}
		}
	}
}

vB_AJAX_MediaRate.prototype.rate = function()
{
	if (this.pseudoform.fetch_variable('vote') != null)
	{
		YAHOO.util.Connect.asyncRequest("POST", "umg_ajax.php?do=mediarate&m=" + mediaid + "&vote=" + PHP.urlencode(this.pseudoform.fetch_variable("vote")), {
			success: this.handle_ajax_response,
			failure: this.handle_ajax_error,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=mediarate&m=" + mediaid + "&" + this.pseudoform.build_query_string());
	}
};

vB_AJAX_MediaRate.prototype.handle_ajax_error = function(ajax)
{
	vBulletin_AJAX_Error_Handler(ajax);
	this.formobj.submit();
}

vB_AJAX_MediaRate.prototype.form_click = function()
{
	var AJAX_MediaRate = new vB_AJAX_MediaRate(this.form);
	AJAX_MediaRate.rate();
	return false;
};
